package com.metapace.printer.sample;

import java.io.FileNotFoundException;
import java.io.InputStream;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.metapace.thermalprinter.MetapacePrinter;

public class NvImageActivity extends Activity implements OnClickListener {

	private static final int REQUEST_CODE_ACTION_PICK = 1;

	private ImageView mImageView;
	private TextView mTextView;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_nv_image);

		mImageView = (ImageView) findViewById(R.id.imageView1);
		mTextView = (TextView) findViewById(R.id.textView2);

		findViewById(R.id.button1).setOnClickListener(this);
		findViewById(R.id.button2).setOnClickListener(this);
		findViewById(R.id.button3).setOnClickListener(this);
	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		if (requestCode == REQUEST_CODE_ACTION_PICK) {
			if (data != null) {
				Uri uri = data.getData();
				InputStream is = null;
				try {
					is = getContentResolver().openInputStream(uri);
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					return;
				}

				BitmapFactory.Options opts = new BitmapFactory.Options();
				opts.inJustDecodeBounds = false;
				opts.inSampleSize = 1;
				opts.inPreferredConfig = Bitmap.Config.RGB_565;
				Bitmap bm = BitmapFactory.decodeStream(is, null, opts);
				mImageView.setImageBitmap(bm);
				
				ContentResolver cr = getContentResolver();
				Cursor c = cr.query(uri, new String[] {MediaStore.Images.Media.DATA}, null, null, null);
				if (c == null || c.getCount() == 0) {
					return;
				}
				c.moveToFirst();
				int columnIndex = c.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
				String text = c.getString(columnIndex);
				mTextView.setText(text);
			}
		}
	}

	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.button1:
			String externalStorageState = Environment.getExternalStorageState();
			if (externalStorageState.equals(Environment.MEDIA_MOUNTED)) {
				Intent intent = new Intent(Intent.ACTION_PICK);
				intent.setType(android.provider.MediaStore.Images.Media.CONTENT_TYPE);
				startActivityForResult(intent, REQUEST_CODE_ACTION_PICK);
			}
			break;

		case R.id.button2:
			defineNvImage();
			break;

		case R.id.button3:
			RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
			int mode = MetapacePrinter.NV_IMAGE_MODE_NORMAL;
			switch (radioGroup.getCheckedRadioButtonId()) {
			case R.id.radio1:
				mode = MetapacePrinter.NV_IMAGE_MODE_DOUBLE_WIDTH;
				break;
				
			case R.id.radio2:
				mode = MetapacePrinter.NV_IMAGE_MODE_DOUBLE_HEIGHT;
				break;
				
			case R.id.radio3:
				mode = MetapacePrinter.NV_IMAGE_MODE_QUARDRUPLE;
				break;
			}
			MainActivity.metapacePrinter.printNvImage(1, mode, true);
			MainActivity.metapacePrinter.printNvImage(2, mode, true);
			MainActivity.metapacePrinter.printNvImage(3, mode, true);
			break;
		}
	}
	
	private void defineNvImage() {
		try {
			EditText editText = (EditText) findViewById(R.id.editText1);
			final int level = Integer.parseInt(editText.getText().toString());

			final String pathName = mTextView.getText().toString();
			
			if (pathName != null && pathName.length() > 0) {
				MainActivity.metapacePrinter.defineNvImage(new MetapacePrinter.NvImageOptions[] {
						new MetapacePrinter.NvImageOptions(pathName, MetapacePrinter.BITMAP_WIDTH_NONE, level),
						new MetapacePrinter.NvImageOptions(pathName, MetapacePrinter.BITMAP_WIDTH_NONE, level),
						new MetapacePrinter.NvImageOptions(pathName, MetapacePrinter.BITMAP_WIDTH_NONE, level)
				});
			} else {
				BitmapDrawable drawable = (BitmapDrawable) getResources().getDrawable(R.drawable.logo);
				Bitmap bitmap = drawable.getBitmap();
				MainActivity.metapacePrinter.defineNvImage(new MetapacePrinter.NvImageOptions[] {
						new MetapacePrinter.NvImageOptions(bitmap, MetapacePrinter.BITMAP_WIDTH_NONE, level),
						new MetapacePrinter.NvImageOptions(bitmap, MetapacePrinter.BITMAP_WIDTH_NONE, level),
						new MetapacePrinter.NvImageOptions(bitmap, MetapacePrinter.BITMAP_WIDTH_NONE, level)
				});
			}
		} catch (NumberFormatException e) {
			e.printStackTrace();
			Toast.makeText(getApplicationContext(), "Please input key code or level.", Toast.LENGTH_SHORT).show();
		}
	}
}
